<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Help-Book-Files-Schema"
                              xmlns:wwhbkfiles="urn:WebWorks-Help-Book-Files-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterLinksType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="wwhbkfiles" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwformat:Transforms/wwhelp_context.xsl" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwlinks-files-by-groupid" match="wwlinks:File" use="@groupID" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/wwhelp_context.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/wwhelp_context.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />

 
 <!-- Links -->
 <!--        -->
 <xsl:variable name="GlobalLinksPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLinksType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLinks" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLinksPath)" />

 
 <xsl:variable name="GlobalBookFilesTemplatePath" select="wwuri:AsFilePath('wwformat:Transforms/wwhelp_files.xml')" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarIgnore1">
    <xsl:value-of select="wwprogress:Start(count($VarProjectGroups))" />
   </xsl:variable>

   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <xsl:variable name="VarIgnore2">
     <xsl:value-of select="wwprogress:Start(1)" />
    </xsl:variable>

    <!-- Determine group output directory path -->
    <!--                                       -->
    <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarProjectGroup/@Name)" />

    <xsl:variable name="VarPath" select="wwfilesystem:Combine($VarGroupOutputDirectoryPath, 'wwhdata/xml/files.xml')" />

    <!-- Get splits info -->
    <!--                 -->
    <xsl:for-each select="$GlobalFiles[1]">
     <!-- Load splits -->
     <!--             -->
     <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitsType))[1]" />
     <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

     <!-- Transform -->
     <!--           -->
     <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, $VarProjectGroup/@ChangeID, $VarProjectGroup/@GroupID, '', $GlobalActionChecksum)" />
     <xsl:if test="not($VarUpToDate)">
      <xsl:variable name="VarResultAsXML">
       <xsl:variable name="VarBookFilesTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalBookFilesTemplatePath)" />

       <xsl:call-template name="BookFiles">
        <xsl:with-param name="ParamBookFilesTemplate" select="$VarBookFilesTemplate" />
        <xsl:with-param name="ParamGroupOutputDirectoryPath" select="$VarGroupOutputDirectoryPath" />
        <xsl:with-param name="ParamProjectGroup" select="$VarProjectGroup" />
        <xsl:with-param name="ParamSplits" select="$VarSplits" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
      <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'xml', '1.0', 'yes')" />
     </xsl:if>

     <!-- Report Files -->
     <!--              -->
     <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{$VarProjectGroup/@ChangeID}" groupID="{$VarProjectGroup/@GroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
      <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
      <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{wwfilesystem:GetChecksum($VarFilesSplits/@path)}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
      <wwfiles:Depends path="{$GlobalLinksPath}" checksum="{wwfilesystem:GetChecksum($GlobalLinksPath)}" groupID="" documentID="" />
      <wwfiles:Depends path="{$GlobalBookFilesTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalBookFilesTemplatePath)}" groupID="" documentID="" />

      <xsl:for-each select="$VarSplits/wwsplits:Splits/wwsplits:Split">
       <xsl:variable name="VarSplit" select="." />

       <wwfiles:Depends path="{$VarSplit/@path}" checksum="{wwfilesystem:GetChecksum($VarSplit/@path)}" groupID="{$VarSplit/@groupID}" documentID="{$VarSplit/@documentID}" />
      </xsl:for-each>
     </wwfiles:File>
    </xsl:for-each>

    <xsl:variable name="VarIgnore3">
     <xsl:value-of select="wwprogress:End()" />
    </xsl:variable>
   </xsl:for-each>

   <xsl:variable name="VarIgnore4">
    <xsl:value-of select="wwprogress:End()" />
   </xsl:variable>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="BookFiles">
  <xsl:param name="ParamBookFilesTemplate" />
  <xsl:param name="ParamGroupOutputDirectoryPath" />
  <xsl:param name="ParamProjectGroup" />
  <xsl:param name="ParamSplits" />

  <xsl:apply-templates select="$ParamBookFilesTemplate" mode="wwmode:wwhbkfiles">
   <xsl:with-param name="ParamGroupOutputDirectoryPath" select="$ParamGroupOutputDirectoryPath" />
   <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   <xsl:with-param name="ParamSplits" select="$ParamSplits" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="/" mode="wwmode:wwhbkfiles">
  <xsl:param name="ParamGroupOutputDirectoryPath" />
  <xsl:param name="ParamProjectGroup" />
  <xsl:param name="ParamSplits" />

  <xsl:apply-templates select="*" mode="wwmode:wwhbkfiles">
   <xsl:with-param name="ParamGroupOutputDirectoryPath" select="$ParamGroupOutputDirectoryPath" />
   <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   <xsl:with-param name="ParamSplits" select="$ParamSplits" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="wwhbkfiles:WebWorksHelpBook" mode="wwmode:wwhbkfiles">
  <xsl:param name="ParamGroupOutputDirectoryPath" />
  <xsl:param name="ParamProjectGroup" />
  <xsl:param name="ParamSplits" />

  <xsl:copy>
   <xsl:copy-of select="@*[(local-name() != 'name') and (local-name() != 'context') and (local-name() != 'locale')]" />
   <xsl:attribute name="name">
    <xsl:call-template name="WWHelpTitle">
     <xsl:with-param name="ParamProject" select="$GlobalProject" />
     <xsl:with-param name="ParamGroupID" select="$ParamProjectGroup/@GroupID" />
    </xsl:call-template>
   </xsl:attribute>
   <xsl:attribute name="context">
    <xsl:call-template name="WWHelpContext">
     <xsl:with-param name="ParamProject" select="$GlobalProject" />
     <xsl:with-param name="ParamGroupID" select="$ParamProjectGroup/@GroupID" />
    </xsl:call-template>
   </xsl:attribute>
   <xsl:attribute name="locale">
    <xsl:value-of select="$GlobalLocale/wwlocale:Locale/@name" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhbkfiles">
    <xsl:with-param name="ParamGroupOutputDirectoryPath" select="$ParamGroupOutputDirectoryPath" />
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
    <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhbkfiles:CommonWordsToSkip" mode="wwmode:wwhbkfiles">
  <xsl:param name="ParamGroupOutputDirectoryPath" />
  <xsl:param name="ParamProjectGroup" />
  <xsl:param name="ParamSplits" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'minlen']" />
   <xsl:attribute name="minlen">
    <xsl:value-of select="$GlobalLocale/wwlocale:Locale/wwlocale:Search/wwlocale:MinimumWordLength/@value" />
   </xsl:attribute>

   <xsl:value-of select="$GlobalLocale/wwlocale:Locale/wwlocale:Search/wwlocale:StopWords/text()" />

   <xsl:value-of select="text()" />
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhbkfiles:DocumentInfo" mode="wwmode:wwhbkfiles">
  <xsl:param name="ParamGroupOutputDirectoryPath" />
  <xsl:param name="ParamProjectGroup" />
  <xsl:param name="ParamSplits" />

  <xsl:copy>
   <xsl:copy-of select="@*" />

   <xsl:for-each select="$ParamSplits/wwsplits:Splits/wwsplits:Split">
    <xsl:variable name="VarSplit" select="." />

    <wwhbkfiles:Document title="{$VarSplit/@title}" href="{wwuri:GetRelativeTo($VarSplit/@path, wwfilesystem:Combine($ParamGroupOutputDirectoryPath, 'dummy.component'))}" />
   </xsl:for-each>

   <xsl:copy-of select="text()" />
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhbkfiles:TopicMap" mode="wwmode:wwhbkfiles">
  <xsl:param name="ParamGroupOutputDirectoryPath" />
  <xsl:param name="ParamProjectGroup" />
  <xsl:param name="ParamSplits" />

  <xsl:copy>
   <xsl:copy-of select="@*" />

   <xsl:for-each select="$GlobalLinks[1]">
    <xsl:variable name="VarGroupFileLinks" select="key('wwlinks-files-by-groupid', $ParamProjectGroup/@GroupID)" />

    <xsl:for-each select="$VarGroupFileLinks">
     <xsl:variable name="VarLinkFile" select="." />

     <xsl:for-each select="$VarLinkFile/wwlinks:Paragraph[string-length(@topic) &gt; 0]">
      <xsl:variable name="VarLinkParagraph" select="." />

      <xsl:variable name="VarHREF">
       <xsl:value-of select="wwuri:GetRelativeTo($VarLinkFile/@path, wwfilesystem:Combine($ParamGroupOutputDirectoryPath, 'dummy.component'))" />
       <xsl:if test="$VarLinkParagraph/@first = 'false'">
        <xsl:text>#</xsl:text>
        <xsl:value-of select="$VarLinkParagraph/@linkid" />
       </xsl:if>
      </xsl:variable>

      <wwhbkfiles:Topic name="{wwstring:WebWorksHelpContextOrTopic($VarLinkParagraph/@topic)}" href="{$VarHREF}" />
     </xsl:for-each>
    </xsl:for-each>
   </xsl:for-each>

   <xsl:copy-of select="text()" />
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhbkfiles:*" mode="wwmode:wwhbkfiles">
  <xsl:param name="ParamGroupOutputDirectoryPath" />
  <xsl:param name="ParamProjectGroup" />
  <xsl:param name="ParamSplits" />

  <xsl:copy>
   <xsl:copy-of select="@*" />

   <xsl:apply-templates select="*" mode="wwmode:wwhbkfiles">
    <xsl:with-param name="ParamGroupOutputDirectoryPath" select="$ParamGroupOutputDirectoryPath" />
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
    <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>
</xsl:stylesheet>
